<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('students', function (Blueprint $table) {
            // 🚨 Tambahkan kolom 'email'
            // Harus nullable dan unik karena tidak semua siswa mungkin punya email
            $table->string('email')->unique()->nullable()->after('name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('students', function (Blueprint $table) {
            // 🚨 Hapus kolom 'email'
            $table->dropColumn('email');
        });
    }
};