

<?php $__env->startSection('title', 'Edit Kelas: ' . $class->name); ?>

<?php $__env->startSection('content_header'); ?>

<div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
    
    
    <h1 class="text-2xl font-bold text-gray-800 flex items-center mb-2 sm:mb-0">
        
        <i class="fas fa-edit text-amber-500 mr-2"></i> 
        <span>Edit Kelas: <?php echo e($class->name); ?></span>
    </h1>
    
    
    <nav class="text-sm font-medium text-gray-500" aria-label="Breadcrumb">
        <ol class="flex space-x-2">
            
            <li><a href="<?php echo e(route('admin.dashboard')); ?>" class="text-indigo-600 hover:text-indigo-800 transition duration-150">Home</a></li>
            <li class="text-gray-400">/</li>
            <li><a href="<?php echo e(route('classes.index')); ?>" class="text-indigo-600 hover:text-indigo-800 transition duration-150">Data Kelas</a></li>
            <li class="text-gray-400">/</li>
            <li class="text-gray-600 font-semibold">Edit Kelas</li>
        </ol>
    </nav>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    
    <div class="grid grid-cols-1 lg:grid-cols-3 lg:gap-6"> 
        
        
        <div class="lg:col-span-2">
            
            <div class="bg-white rounded-xl shadow-lg border border-gray-100" id="classEditFormCard">
                
                
                <div class="p-5 border-b border-gray-100 flex justify-between items-center">
                    <h3 class="text-xl font-bold text-gray-800 flex items-center">
                        <i class="fas fa-chalkboard mr-2 text-indigo-500"></i> Form Edit Kelas
                    </h3>
                    <div class="flex-shrink-0">
                        
                        <a href="<?php echo e(route('classes.index')); ?>" 
                           class="inline-flex items-center px-3 py-1.5 border border-gray-300 text-sm font-medium rounded-lg 
                                  shadow-sm text-gray-700 bg-white hover:bg-gray-100 transition duration-150 transform hover:scale-[1.02]">
                            <i class="fas fa-arrow-left mr-1"></i> Kembali
                        </a>
                    </div>
                </div>

                
                <div class="p-6">
                    <form action="<?php echo e(route('classes.update', $class->id)); ?>" method="POST" id="classEditForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        
                        <?php
                            $baseInputClass = 'w-full px-3 py-2 rounded-lg shadow-sm focus:outline-none transition duration-150';
                            $normalClass = 'border-gray-300 focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500';
                            $errorClass = 'border-red-500 focus:ring-2 focus:ring-red-500 focus:border-red-500';
                        ?>

                        
                        <?php if($errors->any()): ?>
                            <div class="bg-red-50 border-l-4 border-red-500 text-red-700 p-4 rounded-lg relative mb-5" role="alert">
                                <h5 class="font-bold text-base flex items-center mb-2"><i class="icon fas fa-ban mr-2"></i> Terjadi Kesalahan!</h5>
                                <ul class="mb-0 list-disc list-inside text-sm">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        
                        <div class="mb-5">
                            <label for="name" class="block text-sm font-semibold text-gray-700 mb-1">Nama Kelas <span class="text-red-600">*</span></label>
                            <?php $nameStatusClass = $errors->has('name') ? $errorClass : $normalClass; ?>
                            <input type="text"
                                name="name"
                                id="name"
                                class="<?php echo e($baseInputClass); ?> border <?php echo e($nameStatusClass); ?>"
                                value="<?php echo e(old('name', $class->name)); ?>"
                                placeholder="Contoh: X RPL 1"
                                required
                                autofocus>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="mt-1 text-xs text-gray-500 block">Nama Kelas harus unik.</small>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            
                            <div class="mb-5">
                                <label for="grade" class="block text-sm font-semibold text-gray-700 mb-1">Tingkat / Kelas <span class="text-red-600">*</span></label>
                                <?php $gradeStatusClass = $errors->has('grade') ? $errorClass : $normalClass; ?>
                                <select name="grade" 
                                        id="grade" 
                                        class="select2bs4 border <?php echo e($gradeStatusClass); ?>" 
                                        required
                                        style="width: 100%;">
                                    <option value="">Pilih Tingkat (1-12)</option>
                                    <?php for($i = 1; $i <= 12; $i++): ?>
                                        <option value="<?php echo e($i); ?>" <?php echo e(old('grade', $class->grade) == $i ? 'selected' : ''); ?>>
                                            Kelas <?php echo e($i); ?> 
                                            <?php if($i <= 6): ?> (SD) <?php elseif($i <= 9): ?> (SMP) <?php else: ?> <?php endif; ?>
                                        </option>
                                    <?php endfor; ?>
                                </select>
                                <?php $__errorArgs = ['grade'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            
                            <div class="mb-5">
                                <label for="major" class="block text-sm font-semibold text-gray-700 mb-1">Jurusan</label>
                                <?php $majorStatusClass = $errors->has('major') ? $errorClass : $normalClass; ?>
                                <select name="major" 
                                        id="major" 
                                        class="select2bs4 border <?php echo e($majorStatusClass); ?>" 
                                        style="width: 100%;">
                                    <option value="">Pilih Jurusan (Opsional)</option>
                                    <?php $__currentLoopData = ['RPL', 'TKJ', 'MM', 'AKL', 'OTKP', 'BDP', 'TBG', 'PH', 'UMUM']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $major): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($major); ?>" <?php echo e(old('major', $class->major ?? '') == $major ? 'selected' : ''); ?>>
                                            <?php echo e($major); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['major'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="mt-1 text-xs text-gray-500 block">Pilih "UMUM" jika tidak ada jurusan khusus.</small>
                            </div>
                        </div>

                        
                        <div class="mb-5">
                            <label for="description" class="block text-sm font-semibold text-gray-700 mb-1">Keterangan</label>
                            <?php $descStatusClass = $errors->has('description') ? $errorClass : $normalClass; ?>
                            <textarea name="description"
                                id="description"
                                class="<?php echo e($baseInputClass); ?> border <?php echo e($descStatusClass); ?>"
                                rows="3"
                                placeholder="Keterangan tambahan tentang kelas..."><?php echo e(old('description', $class->description ?? '')); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="mt-1 text-xs text-gray-500 block">
                                <span id="char-count"><?php echo e(strlen(old('description', $class->description ?? ''))); ?></span>/500 karakter
                            </small>
                        </div>

                        
                        <div class="mb-5">
                            <label for="status" class="block text-sm font-semibold text-gray-700 mb-1">Status</label>
                            <?php $statusStatusClass = $errors->has('status') ? $errorClass : $normalClass; ?>
                            <select name="status" id="status" class="select2bs4 border <?php echo e($statusStatusClass); ?>" style="width: 100%;">
                                <option value="active" <?php echo e(old('status', $class->status ?? 'active') == 'active' ? 'selected' : ''); ?>>Aktif</option>
                                <option value="inactive" <?php echo e(old('status', $class->status ?? 'active') == 'inactive' ? 'selected' : ''); ?>>Non-Aktif</option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 flex items-center"><i class="fas fa-exclamation-circle mr-1"></i> <?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="mt-1 text-xs text-gray-500 block">Kelas non-aktif tidak akan muncul dalam pemilihan absensi.</small>
                        </div>

                        
                        <div class="mt-6 flex justify-between items-center border-t border-gray-100 pt-5">
                            <div>
                                
                                <button type="submit" 
                                        class="inline-flex items-center px-5 py-2.5 border border-transparent text-base font-bold rounded-lg shadow-md 
                                                text-gray-800 bg-amber-400 hover:bg-amber-500 focus:outline-none focus:ring-4 focus:ring-offset-2 focus:ring-amber-500/50 
                                                transition duration-150 transform hover:-translate-y-0.5" 
                                        id="submitEditBtn">
                                    <i class="fas fa-save mr-2"></i> Perbarui Data
                                </button>
                                
                                <a href="<?php echo e(route('classes.index')); ?>" 
                                   class="inline-flex items-center px-4 py-2.5 border border-gray-300 text-base font-medium rounded-lg 
                                          text-gray-700 bg-white hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition duration-150 ml-3">
                                    <i class="fas fa-times mr-2"></i> Batal
                                </a>
                            </div>
                            
                            
                            <button type="button" 
                                    class="inline-flex items-center px-4 py-2.5 border border-transparent text-base font-bold rounded-lg shadow-md 
                                            text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-4 focus:ring-offset-2 focus:ring-red-500/50 
                                            transition duration-150 transform hover:scale-[1.05]"
                                    onclick="confirmDelete(<?php echo e($class->id); ?>, '<?php echo e($class->name); ?>')">
                                <i class="fas fa-trash mr-1"></i> Hapus Kelas
                            </button>
                        </div>
                    </form>

                    <form id="delete-form-<?php echo e($class->id); ?>" 
                          action="<?php echo e(route('classes.destroy', $class->id)); ?>" 
                          method="POST" class="hidden">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                    </form>
                </div>
            </div>
        </div>

        
        <div class="lg:col-span-1 mt-6 lg:mt-0">
            <div class="bg-white rounded-xl shadow-lg border border-gray-100">
                
                
                <div class="p-5 border-b border-gray-100">
                    <h3 class="text-xl font-bold text-gray-800 flex items-center">
                        <i class="fas fa-info-circle mr-2 text-indigo-500"></i> Informasi Kelas
                    </h3>
                </div>
                
                
                <div class="p-6">
                    
                    
                    <div class="bg-indigo-50 border-l-4 border-indigo-500 p-4 mb-6 text-indigo-700 rounded-lg">
                        <h6 class="text-base font-bold mb-2 flex items-center">
                            <i class="fas fa-lightbulb mr-2"></i>Tips:
                        </h6>
                        <ul class="mb-0 pl-3 text-sm list-disc list-inside text-gray-700">
                            <li>**Tingkat (Grade)**: Gunakan angka 1 sampai 12 untuk semua jenjang.</li>
                            <li>**Nama Kelas** harus tetap unik.</li>
                            <li>Penghapusan kelas hanya bisa dilakukan jika tidak ada siswa atau wali kelas yang ditugaskan.</li>
                        </ul>
                    </div>

                    
                    <div class="mt-3">
                        <small class="text-xs text-gray-500 font-semibold uppercase tracking-wider block mb-2">Detail Saat Ini:</small>
                        <div class="border rounded-lg p-4 bg-gray-50 space-y-2">
                            <div class="flex justify-between"><span>Nama:</span> <strong class="text-gray-800"><?php echo e($class->name); ?></strong></div>
                            <div class="flex justify-between"><span>Tingkat:</span> <strong class="text-gray-800"><?php echo e($class->grade); ?></strong></div>
                            <div class="flex justify-between"><span>Jurusan:</span> <strong class="text-gray-800"><?php echo e($class->major ?? '-'); ?></strong></div>
                            <div class="flex justify-between pt-2 border-t border-gray-200">
                                <span>Status:</span>
                                <span class="px-3 py-1 text-xs font-bold rounded-full 
                                             <?php echo e($class->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-gray-200 text-gray-600'); ?>">
                                    <?php echo e($class->status == 'active' ? 'Aktif' : 'Non-Aktif'); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="mt-4">
                        <small class="text-xs text-gray-500 font-semibold uppercase tracking-wider block mb-2">Preview Nama Kelas:</small>
                        <div class="border rounded-lg p-4 bg-gray-50">
                            <code id="class-preview" class="text-sm font-mono text-gray-800"><?php echo e($class->name); ?></code>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo e(asset('template/adminlte/plugins/select2/js/select2.full.min.js')); ?>"></script>
<script>
    // --- FUNGSI HAPUS KELAS (Mengganti warna tombol ke Tailwind) ---
    function confirmDelete(id, className) {
        Swal.fire({
            title: 'Hapus Kelas?',
            html: `Yakin ingin menghapus kelas <strong>${className}</strong>?<br>Tindakan ini tidak dapat dibatalkan dan akan mempengaruhi data siswa terkait.`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc2626', // red-600
            cancelButtonColor: '#4f46e5', // indigo-600
            confirmButtonText: 'Ya, Hapus!',
            cancelButtonText: 'Batal',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById(`delete-form-${id}`).submit();
            }
        });
    }

    $(document).ready(function() {
        // Initialize Select2 for Grade input
        // Menggunakan Select2 untuk Grade, Major, dan Status
        $('.select2bs4').select2({
            theme: 'bootstrap4',
            placeholder: 'Pilih',
            allowClear: true
        });

        // FUNGSI UPDATE PREVIEW NAMA KELAS
        function updateClassPreview() {
            const grade = $('#grade').val();
            const major = $('#major').val(); // Ambil nilai mentah major
            const nameInput = $('#name').val().trim();
            
            let previewText = nameInput || 'Tulis Nama Kelas...';
            
            // Logika untuk menampilkan preview jika Nama Kelas diinput
            $('#class-preview').text(previewText);

            // Jika ada perubahan di input utama, beri warna text warning (amber)
            if (nameInput !== '<?php echo e($class->name); ?>' || grade !== '<?php echo e($class->grade); ?>' || major !== '<?php echo e($class->major ?? ''); ?>') {
                $('#class-preview').addClass('text-red-500 font-bold').removeClass('text-gray-800');
            } else {
                $('#class-preview').removeClass('text-red-500 font-bold').addClass('text-gray-800');
            }
        }
        
        // --- EVENT LISTENERS ---

        // Auto-update preview when any relevant field changes
        $('#grade, #major, #name').on('change keyup', function() {
            updateClassPreview();
        });

        // Show character count for description
        $('#description').on('input', function() {
            const maxLength = 500;
            let currentText = $(this).val();
            
            if (currentText.length > maxLength) {
                currentText = currentText.substring(0, maxLength);
                $(this).val(currentText);
            }

            $('#char-count').text(currentText.length);
        });
        
        // Form submission loading state
        $('#classEditForm').on('submit', function() {
            const submitBtn = $('#submitEditBtn');
            submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i> Memperbarui...');
        });

        // Initialize preview on page load
        updateClassPreview(); 
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminlte', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\e-absensi-siswa\resources\views/admin/classes/edit.blade.php ENDPATH**/ ?>